/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.Activation.Busy;
import com.visigenic.vbroker.Activation.FailedToExecute;
import com.visigenic.vbroker.Activation.NotRegistered;
import com.visigenic.vbroker.Activation.NotResponding;
import com.visigenic.vbroker.Activation.OAD;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.interceptor.Closure;
import com.visigenic.vbroker.interceptor.DefaultServerInterceptor;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.PersistentId;
import com.visigenic.vbroker.orb.ServiceId;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CORBA.portable.InputStream;

class OADInterceptor
extends DefaultServerInterceptor {
    private OAD _oad;
    private ORB _orb;
    private boolean _verbose;

    OADInterceptor(OAD oAD, ORB oRB, boolean bl) {
        this._oad = oAD;
        this._orb = oRB;
        this._verbose = bl;
        if (this._verbose) {
            System.out.println("Completed construction of OAD's Location-Forwarder");
        }
    }

    public IOR locate(int n, byte[] byArray, Closure closure) {
        Object object;
        if (this._verbose) {
            System.out.println("Received a locate request...");
        }
        if ((object = this.lookup_object(byArray)) == null) {
            return null;
        }
        String string = this._orb.object_to_string(object);
        if (this._verbose) {
            System.out.println("...obtained an object with reference [" + string + "]");
        }
        return this._orb.string_to_ior(string);
    }

    public InputStream receive_request(RequestHeader requestHeader, ObjectHolder objectHolder, InputStream inputStream, Closure closure) {
        Object object;
        if (this._verbose) {
            System.out.println("Received a request [" + requestHeader.operation + "]");
        }
        if ((object = this.lookup_object(requestHeader.object_key)) != null) {
            objectHolder.value = object;
        }
        return null;
    }

    Object lookup_object(byte[] byArray) {
        ObjectId objectId = this._orb.toObjectId(byArray);
        String string = null;
        String string2 = null;
        if (objectId instanceof PersistentId) {
            string = ((PersistentId)objectId).repId();
            string2 = ((PersistentId)objectId).objectName();
            if (this._verbose) {
                System.out.println("OAD request for PERSISTENT object [" + string + "/" + string2 + "]");
            }
        } else if (objectId instanceof ServiceId) {
            string = "*";
            string2 = ((ServiceId)objectId).serviceName();
            if (this._verbose) {
                System.out.println("OAD request for SERVICE object [" + string2 + "]");
            }
        } else if (this._verbose) {
            System.out.println("Request with unexpected ObjectId: " + objectId);
        }
        if (string != null && !this._isOAD(string)) {
            try {
                if (this._verbose) {
                    System.out.println("Lookup up implementation...");
                }
                if (string2 == null || string2.equals("")) {
                    return this._oad.lookup_interface(string, -1);
                }
                return this._oad.lookup_implementation(string, string2, -1);
            }
            catch (NotRegistered notRegistered) {
                this._logError("Locate interceptor", notRegistered);
            }
            catch (NotResponding notResponding) {
                this._logError("Locate interceptor", notResponding);
            }
            catch (Busy busy) {
                this._logError("Locate interceptor", busy);
            }
            catch (FailedToExecute failedToExecute) {
                this._logError("Locate interceptor", failedToExecute);
            }
        }
        return null;
    }

    private boolean _isOAD(String string) {
        return string.indexOf("Activation") >= 0 && string.indexOf("OAD") >= 0;
    }

    private void _logError(String string, Exception exception) {
        if (this._verbose) {
            System.out.println(String.valueOf(string) + " caught exception: " + exception);
        }
    }
}

